$(alectra).ready(function() {

    function validEmail(email) {
        var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }


    $("#frmConfig").submit(function(event) {
        event.preventDefault();
        var error = false;
        var email = $("#email_result").val();

        $(".required").each(function() {
            if ($.trim($(this).val()).length < 1) {
                $(this).removeClass("is-valid is-invalid");
                $(this).addClass("is-invalid");
                error = true;
            } else {
                $(this).removeClass("is-valid is-invalid");
                $(this).addClass("is-valid");
            }
        });


        if (!validEmail(email)) {
            $("#email_result").removeClass("is-valid is-invalid");
            $("#email_result").addClass("is-invalid");
            error = true;
        } else {
            $("#email_result").removeClass("is-valid is-invalid");
            $("#email_result").addClass("is-valid");
        }
        

        if(!error){
            $("#update").prop("disabled", true);
            $("#update").html('<span class="spinner-border spinner-border-sm mr-2" role="status"></span> Update configuration');
            var payload = $("#frmConfig").serialize();
            $.post( "ajax.php?route=update", payload).done(function( data ) {
                if(data == "ok"){
                $("#configMsg").slideDown().delay(2e3).slideUp();
                $("#update").prop("disabled", false);
                $("#update").html('Update configuration');
                }else{
                    $("#configMsgError").slideDown().delay(2e3).slideUp();
                $("#update").prop("disabled", false);
                $("#update").html('Update configuration');
                }
            });
        }

    });
});